$(document).ready(function() {
    // Check if currency variables are defined in DOM
    console.log('Currency variables check from DOM:', {
        __symbol: $('#__symbol').val(),
        __symbol_placement: $('#__symbol_placement').val(),
        __precision: $('#__precision').val()
    });
    
    // Test if the compact formatting function is available
    if (typeof __currency_format_compact === 'function') {
        console.log('__currency_format_compact function is available');
        console.log('Test compact formatting:', __currency_format_compact(1200000, true));
    } else {
        console.error('__currency_format_compact function is NOT available');
    }
    
    // Apply compact formatting to dashboard elements on page load
    setTimeout(function() {
        __apply_dashboard_compact_formatting();
    }, 500);
    
    // Set up observer to automatically apply compact formatting when dashboard elements change
    setTimeout(function() {
        __setup_dashboard_compact_observer();
    }, 1000);
    
    if ($('#dashboard_date_filter').length == 1) {
        dateRangeSettings.startDate = moment();
        dateRangeSettings.endDate = moment();
        $('#dashboard_date_filter').daterangepicker(dateRangeSettings, function(start, end) {
            $('#dashboard_date_filter span').html(
                start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
            );
            update_statistics(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
            if ($('#quotation_table').length && $('#dashboard_location').length) {
                quotation_datatable.ajax.reload();
            }
        });

        // Call update_statistics on page load to ensure dashboard data is loaded and formatted
        update_statistics(moment().format('YYYY-MM-DD'), moment().format('YYYY-MM-DD'));
    } else {
        // If no date filter, still load dashboard data on page load
        update_statistics(moment().format('YYYY-MM-DD'), moment().format('YYYY-MM-DD'));
    }

    $('#dashboard_location').change( function(e) {
        var start = $('#dashboard_date_filter')
                    .data('daterangepicker')
                    .startDate.format('YYYY-MM-DD');

        var end = $('#dashboard_date_filter')
                    .data('daterangepicker')
                    .endDate.format('YYYY-MM-DD');

        update_statistics(start, end);
    });

    //atock alert datatables
    var stock_alert_table = $('#stock_alert_table').DataTable({
        processing: true,
        serverSide: true,
        ordering: false,
        searching: false,
        scrollY:        "75vh",
        scrollX:        true,
        scrollCollapse: true,
        fixedHeader: false,
        dom: 'Btirp',
        ajax: {
            "url": '/home/product-stock-alert',
            "data": function ( d ) {
                if ($('#stock_alert_location').length > 0) {
                    d.location_id = $('#stock_alert_location').val();
                }
            }
        },
        fnDrawCallback: function(oSettings) {
            __currency_convert_recursively($('#stock_alert_table'));
        },
    });

    $('#stock_alert_location').change( function(){
        stock_alert_table.ajax.reload();
    });
    //payment dues datatables
    purchase_payment_dues_table = $('#purchase_payment_dues_table').DataTable({
        processing: true,
        serverSide: true,
        ordering: false,
        searching: false,
        scrollY:        "75vh",
        scrollX:        true,
        scrollCollapse: true,
        fixedHeader: false,
        dom: 'Btirp',
        ajax: {
            "url": '/home/purchase-payment-dues',
            "data": function ( d ) {
                if ($('#purchase_payment_dues_location').length > 0) {
                    d.location_id = $('#purchase_payment_dues_location').val();
                }
            }
        },
        fnDrawCallback: function(oSettings) {
            __currency_convert_recursively($('#purchase_payment_dues_table'));
        },
    });

    $('#purchase_payment_dues_location').change( function(){
        purchase_payment_dues_table.ajax.reload();
    });

    //Sales dues datatables
    sales_payment_dues_table = $('#sales_payment_dues_table').DataTable({
        processing: true,
        serverSide: true,
        ordering: false,
        searching: false,
        scrollY:        "75vh",
        scrollX:        true,
        scrollCollapse: true,
        fixedHeader: false,
        dom: 'Btirp',
        ajax: {
            "url": '/home/sales-payment-dues',
            "data": function ( d ) {
                if ($('#sales_payment_dues_location').length > 0) {
                    d.location_id = $('#sales_payment_dues_location').val();
                }
            }
        },
        fnDrawCallback: function(oSettings) {
            __currency_convert_recursively($('#sales_payment_dues_table'));
        },
    });

    $('#sales_payment_dues_location').change( function(){
        sales_payment_dues_table.ajax.reload();
    });

    //Stock expiry report table
    stock_expiry_alert_table = $('#stock_expiry_alert_table').DataTable({
        processing: true,
        serverSide: true,
        searching: false,
        scrollY:        "75vh",
        scrollX:        true,
        scrollCollapse: true,
        fixedHeader: false,
        dom: 'Btirp',
        ajax: {
            url: '/reports/stock-expiry',
            data: function(d) {
                d.exp_date_filter = $('#stock_expiry_alert_days').val();
            },
        },
        order: [[3, 'asc']],
        columns: [
            { data: 'product', name: 'p.name' },
            { data: 'location', name: 'l.name' },
            { data: 'stock_left', name: 'stock_left' },
            { data: 'exp_date', name: 'exp_date' },
        ],
        fnDrawCallback: function(oSettings) {
            __show_date_diff_for_human($('#stock_expiry_alert_table'));
            __currency_convert_recursively($('#stock_expiry_alert_table'));
        },
    });

    if ($('#quotation_table').length) {
        quotation_datatable = $('#quotation_table').DataTable({
            processing: true,
            serverSide: true,
            fixedHeader:false,
            aaSorting: [[0, 'desc']],
            "ajax": {
                "url": '/sells/draft-dt?is_quotation=1',
                "data": function ( d ) {
                    if ($('#dashboard_location').length > 0) {
                        d.location_id = $('#dashboard_location').val();
                    }
                }
            },
            columnDefs: [ {
                "targets": 4,
                "orderable": false,
                "searchable": false
            } ],
            columns: [
                { data: 'transaction_date', name: 'transaction_date'  },
                { data: 'invoice_no', name: 'invoice_no'},
                { data: 'name', name: 'contacts.name'},
                { data: 'business_location', name: 'bl.name'},
                { data: 'action', name: 'action'}
            ]            
        });
    }
});

function update_statistics(start, end) {
    var location_id = '';
    if ($('#dashboard_location').length > 0) {
        location_id = $('#dashboard_location').val();
    }
    var data = { start: start, end: end, location_id: location_id };
    //get purchase details
    var loader = '<i class="fas fa-sync fa-spin fa-fw margin-bottom"></i>';
    $('.total_purchase').html(loader);
    $('.purchase_due').html(loader);
    $('.total_sell').html(loader);
    $('.invoice_due').html(loader);
    $('.total_expense').html(loader);
    $('.total_purchase_return').html(loader);
    $('.total_sell_return').html(loader);
    $('.net').html(loader);
    $.ajax({
        method: 'get',
        url: '/home/get-totals',
        dataType: 'json',
        data: data,
        success: function(data) {
            console.log('Dashboard data received:', data);
            console.log('Data types:', {
                total_purchase: typeof data.total_purchase + ' - ' + data.total_purchase,
                total_sell: typeof data.total_sell + ' - ' + data.total_sell,
                invoice_due: typeof data.invoice_due + ' - ' + data.invoice_due,
                purchase_due: typeof data.purchase_due + ' - ' + data.purchase_due,
                total_expense: typeof data.total_expense + ' - ' + data.total_expense,
                net: typeof data.net + ' - ' + data.net
            });
            
            //purchase details - using compact format for dashboard
            $('.total_purchase').html(__currency_format_compact(data.total_purchase, true)).data('original-value', data.total_purchase);
            $('.purchase_due').html(__currency_format_compact(data.purchase_due, true)).data('original-value', data.purchase_due);

            //sell details - using compact format for dashboard
            $('.total_sell').html(__currency_format_compact(data.total_sell, true)).data('original-value', data.total_sell);
            $('.invoice_due').html(__currency_format_compact(data.invoice_due, true)).data('original-value', data.invoice_due);
            //expense details - using compact format for dashboard
            $('.total_expense').html(__currency_format_compact(data.total_expense, true)).data('original-value', data.total_expense);
            var total_purchase_return = data.total_purchase_return - data.total_purchase_return_paid;
            $('.total_purchase_return').html(__currency_format_compact(total_purchase_return, true)).data('original-value', total_purchase_return);
            var total_sell_return_due = data.total_sell_return - data.total_sell_return_paid;
            $('.total_sell_return').html(__currency_format_compact(total_sell_return_due, true)).data('original-value', total_sell_return_due);
            $('.total_sr').html(__currency_format_compact(data.total_sell_return, true)).data('original-value', data.total_sell_return);
            $('.total_srp').html(__currency_format_compact(data.total_sell_return_paid, true)).data('original-value', data.total_sell_return_paid);
            $('.total_pr').html(__currency_format_compact(data.total_purchase_return, true)).data('original-value', data.total_purchase_return);
            $('.total_prp').html(__currency_format_compact(data.total_purchase_return_paid, true)).data('original-value', data.total_purchase_return_paid);
            $('.net').html(__currency_format_compact(data.net, true)).data('original-value', data.net);

            // assign tooltip total_sell_return 
            var lang = $('#total_srp').data('value');
            var splitlang = lang.split('-');
            
            var newContent = "<p class='mb-0 text-muted fs-10 mt-5'>" + splitlang[0] + ": <span class=''>" + __currency_format_compact(data.total_sell_return, true) + "</span><br>" + splitlang[1] + ": <span class=''>" + __currency_format_compact(data.total_sell_return_paid, true) + "</span></p>";
            $('#total_srp').attr('data-content', newContent)
            // assign tooltip total_purchase_return 
            var lang = $('#total_prp').data('value');
            var splitlang = lang.split('-');
            
            var newContent = "<p class='mb-0 text-muted fs-10 mt-5'>" + splitlang[0] + ": <span class=''>" + __currency_format_compact(data.total_purchase_return, true) + "</span><br>" + __currency_format_compact(data.total_purchase_return_paid, true) + "</span></p>";
            
            $('#total_prp').attr('data-content', newContent);
            
            console.log('Dashboard compact formatting applied successfully');
            
            // Apply compact formatting to ensure all dashboard elements are properly formatted
            setTimeout(function() {
                console.log('Applying dashboard compact formatting...');
                // Don't call __currency_convert_recursively here as it overrides the compact formatting
                __apply_dashboard_compact_formatting();
                
                // Set up periodic check to restore compact formatting if overridden
                setInterval(function() {
                    restoreDashboardCompactFormatting();
                }, 2000); // Check every 2 seconds
            }, 100);
        },
    });
}

// Function to restore compact formatting if dashboard values get overridden
function restoreDashboardCompactFormatting() {
    var dashboardSelectors = [
        '.total_sell',
        '.total_purchase', 
        '.invoice_due',
        '.purchase_due',
        '.total_expense',
        '.total_purchase_return',
        '.total_sell_return',
        '.net'
    ];
    
    dashboardSelectors.forEach(function(selector) {
        var element = $(selector);
        if (element.length > 0) {
            var currentText = element.text();
            var originalValue = element.data('original-value');
            
            // If the element has an original value but the current text doesn't look like compact formatting
            if (originalValue !== undefined && originalValue !== null && 
                (!currentText || currentText === '0' || currentText === '0.00' || 
                 (!currentText.includes('K') && !currentText.includes('M') && !currentText.includes('B') && !currentText.includes('T')))) {
                
                console.log('Restoring compact formatting for:', selector, 'Original value:', originalValue);
                var formattedValue = __currency_format_compact(originalValue, true);
                element.text(formattedValue);
            }
        }
    });
}
